/*
 * Decompiled with CFR 0.152.
 */
package net.coreprotect.database.rollback;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import net.coreprotect.bukkit.BukkitAdapter;
import net.coreprotect.database.Lookup;
import net.coreprotect.model.BlockGroup;
import net.coreprotect.utility.Util;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.block.BlockState;
import org.bukkit.block.Jukebox;
import org.bukkit.block.ShulkerBox;
import org.bukkit.block.banner.Pattern;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.ItemFrame;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.BannerMeta;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.CrossbowMeta;
import org.bukkit.inventory.meta.FireworkEffectMeta;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.MapMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.inventory.meta.SuspiciousStewMeta;
import org.bukkit.potion.PotionEffect;
import org.bukkit.util.io.BukkitObjectInputStream;

public class RollbackUtil
extends Lookup {
    protected static int modifyContainerItems(Material type, Object container, int slot, ItemStack itemstack, int action) {
        int modifiedArmor = -1;
        try {
            ItemStack[] contents = null;
            if (type != null && type.equals((Object)Material.ARMOR_STAND)) {
                EntityEquipment equipment = (EntityEquipment)container;
                if (equipment != null) {
                    if (action == 1) {
                        itemstack.setAmount(1);
                    } else {
                        itemstack.setType(Material.AIR);
                        itemstack.setAmount(0);
                    }
                    if (slot < 4) {
                        contents = equipment.getArmorContents();
                        if (slot >= 0) {
                            contents[slot] = itemstack;
                        }
                        equipment.setArmorContents(contents);
                    } else {
                        ArmorStand armorStand = (ArmorStand)equipment.getHolder();
                        armorStand.setArms(true);
                        switch (slot) {
                            case 4: {
                                equipment.setItemInMainHand(itemstack);
                                break;
                            }
                            case 5: {
                                equipment.setItemInOffHand(itemstack);
                            }
                        }
                    }
                }
            } else if (type != null && type.equals((Object)Material.ITEM_FRAME)) {
                ItemFrame frame = (ItemFrame)container;
                if (frame != null) {
                    if (action == 1) {
                        itemstack.setAmount(1);
                    } else {
                        itemstack.setType(Material.AIR);
                        itemstack.setAmount(0);
                    }
                    frame.setItem(itemstack);
                }
            } else if (type != null && type.equals((Object)Material.JUKEBOX)) {
                Jukebox jukebox = (Jukebox)container;
                if (jukebox != null) {
                    if (action == 1 && itemstack.getType().name().startsWith("MUSIC_DISC")) {
                        itemstack.setAmount(1);
                    } else {
                        itemstack.setType(Material.AIR);
                        itemstack.setAmount(0);
                    }
                    jukebox.setRecord(itemstack);
                    jukebox.update();
                }
            } else {
                Inventory inventory = (Inventory)container;
                if (inventory != null) {
                    boolean isPlayerInventory = inventory instanceof PlayerInventory;
                    if (action == 1) {
                        int amount = itemstack.getAmount();
                        itemstack.setAmount(1);
                        for (int count = 0; count < amount; ++count) {
                            PlayerInventory playerInventory;
                            ItemStack offhand;
                            boolean addedItem = false;
                            if (isPlayerInventory) {
                                int setArmor = Util.setPlayerArmor((PlayerInventory)inventory, itemstack);
                                addedItem = setArmor > -1;
                                int n = modifiedArmor = addedItem ? setArmor : modifiedArmor;
                            }
                            if (!addedItem) {
                                if (BukkitAdapter.ADAPTER.isChiseledBookshelf(type)) {
                                    ItemStack[] inventoryContents = inventory.getStorageContents();
                                    int i = 0;
                                    for (ItemStack stack : inventoryContents) {
                                        if (stack == null) {
                                            inventoryContents[i] = itemstack;
                                            addedItem = true;
                                            break;
                                        }
                                        ++i;
                                    }
                                    if (addedItem) {
                                        inventory.setStorageContents(inventoryContents);
                                    } else {
                                        addedItem = inventory.addItem(new ItemStack[]{itemstack}).size() == 0;
                                    }
                                } else {
                                    boolean bl = addedItem = inventory.addItem(new ItemStack[]{itemstack}).size() == 0;
                                }
                            }
                            if (addedItem || !isPlayerInventory || (offhand = (playerInventory = (PlayerInventory)inventory).getItemInOffHand()) != null && offhand.getType() != Material.AIR && (!itemstack.isSimilar(offhand) || offhand.getAmount() >= offhand.getMaxStackSize())) continue;
                            ItemStack setOffhand = itemstack.clone();
                            if (itemstack.isSimilar(offhand)) {
                                setOffhand.setAmount(offhand.getAmount() + 1);
                            }
                            playerInventory.setItemInOffHand(setOffhand);
                        }
                    } else {
                        int removeAmount = itemstack.getAmount();
                        ItemStack removeMatch = itemstack.clone();
                        removeMatch.setAmount(1);
                        ItemStack[] inventoryContents = (ItemStack[])(isPlayerInventory ? inventory.getContents() : inventory.getStorageContents()).clone();
                        for (int i = inventoryContents.length - 1; i >= 0; --i) {
                            if (inventoryContents[i] != null) {
                                int maxAmount;
                                ItemStack itemStack = inventoryContents[i].clone();
                                int currentAmount = maxAmount = itemStack.getAmount();
                                itemStack.setAmount(1);
                                if (itemStack.toString().equals(removeMatch.toString())) {
                                    for (int scan = 0; scan < maxAmount && removeAmount > 0; --removeAmount, ++scan) {
                                        itemStack.setAmount(--currentAmount);
                                    }
                                } else {
                                    itemStack.setAmount(maxAmount);
                                }
                                inventoryContents[i] = itemStack.getAmount() == 0 ? null : itemStack;
                            }
                            if (removeAmount == 0) break;
                        }
                        if (isPlayerInventory) {
                            inventory.setContents(inventoryContents);
                        } else {
                            inventory.setStorageContents(inventoryContents);
                        }
                        for (int count = 0; count < removeAmount; ++count) {
                            inventory.removeItem(new ItemStack[]{removeMatch});
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return modifiedArmor;
    }

    public static void sortContainerItems(PlayerInventory inventory, List<Integer> modifiedArmorSlots) {
        try {
            ItemStack[] armorContents = inventory.getArmorContents();
            ItemStack[] storageContents = inventory.getStorageContents();
            block2: for (int armor = 0; armor < armorContents.length; ++armor) {
                ItemStack armorItem = armorContents[armor];
                if (armorItem == null || !modifiedArmorSlots.contains(armor)) continue;
                for (int storage = 0; storage < storageContents.length; ++storage) {
                    ItemStack storageItem = storageContents[storage];
                    if (storageItem != null) continue;
                    storageContents[storage] = armorItem;
                    armorContents[armor] = null;
                    continue block2;
                }
            }
            inventory.setArmorContents(armorContents);
            inventory.setStorageContents(storageContents);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void buildFireworkEffect(FireworkEffect.Builder effectBuilder, Material rowType, ItemStack itemstack) {
        try {
            FireworkEffect effect = effectBuilder.build();
            if (rowType == Material.FIREWORK_ROCKET) {
                FireworkMeta meta = (FireworkMeta)itemstack.getItemMeta();
                meta.addEffect(effect);
                itemstack.setItemMeta((ItemMeta)meta);
            } else if (rowType == Material.FIREWORK_STAR) {
                FireworkEffectMeta meta = (FireworkEffectMeta)itemstack.getItemMeta();
                meta.setEffect(effect);
                itemstack.setItemMeta((ItemMeta)meta);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Object[] populateItemStack(ItemStack itemstack, Object list) {
        int slot = 0;
        String faceData = "";
        try {
            Material rowType = itemstack.getType();
            List metaList = (List)list;
            if (metaList.size() > 0 && !(metaList.get(0) instanceof List)) {
                if (rowType.name().endsWith("_BANNER")) {
                    BannerMeta meta = (BannerMeta)itemstack.getItemMeta();
                    for (Object value : metaList) {
                        if (!(value instanceof Map)) continue;
                        Pattern pattern = new Pattern((Map)value);
                        meta.addPattern(pattern);
                    }
                    itemstack.setItemMeta((ItemMeta)meta);
                } else if (BlockGroup.SHULKER_BOXES.contains(rowType)) {
                    BlockStateMeta meta = (BlockStateMeta)itemstack.getItemMeta();
                    ShulkerBox shulkerBox = (ShulkerBox)meta.getBlockState();
                    for (Object value : metaList) {
                        ItemStack item = Util.unserializeItemStackLegacy(value);
                        if (item == null) continue;
                        shulkerBox.getInventory().addItem(new ItemStack[]{item});
                    }
                    meta.setBlockState((BlockState)shulkerBox);
                    itemstack.setItemMeta((ItemMeta)meta);
                }
                return new Object[]{slot, faceData, itemstack};
            }
            int itemCount = 0;
            FireworkEffect.Builder effectBuilder = FireworkEffect.builder();
            for (List map : (List)list) {
                LeatherArmorMeta meta;
                Color color;
                Object meta2;
                if (map.size() == 0) {
                    if (itemCount == 3 && (rowType == Material.FIREWORK_ROCKET || rowType == Material.FIREWORK_STAR)) {
                        RollbackUtil.buildFireworkEffect(effectBuilder, rowType, itemstack);
                        itemCount = 0;
                    }
                    ++itemCount;
                    continue;
                }
                Map mapData = (Map)map.get(0);
                if (mapData.get("slot") != null) {
                    slot = (Integer)mapData.get("slot");
                } else if (mapData.get("facing") != null) {
                    faceData = (String)mapData.get("facing");
                } else if (mapData.get("modifiers") != null) {
                    Object entry2;
                    ItemMeta itemMeta = itemstack.getItemMeta();
                    if (itemMeta.hasAttributeModifiers()) {
                        for (Object entry2 : itemMeta.getAttributeModifiers().entries()) {
                            itemMeta.removeAttributeModifier((Attribute)entry2.getKey(), (AttributeModifier)entry2.getValue());
                        }
                    }
                    List modifiers = (List)mapData.get("modifiers");
                    entry2 = modifiers.iterator();
                    while (entry2.hasNext()) {
                        Object item = entry2.next();
                        Map modifiersMap = (Map)item;
                        for (Map.Entry entry3 : modifiersMap.entrySet()) {
                            try {
                                Attribute attribute = (Attribute)entry3.getKey();
                                AttributeModifier modifier = AttributeModifier.deserialize((Map)((Map)entry3.getValue()));
                                itemMeta.addAttributeModifier(attribute, modifier);
                            }
                            catch (IllegalArgumentException illegalArgumentException) {}
                        }
                    }
                    itemstack.setItemMeta(itemMeta);
                } else if (itemCount == 0) {
                    meta2 = Util.deserializeItemMeta(itemstack.getItemMeta().getClass(), (Map)map.get(0));
                    itemstack.setItemMeta((ItemMeta)meta2);
                    if (map.size() > 1 && rowType == Material.POTION) {
                        PotionMeta subMeta = (PotionMeta)itemstack.getItemMeta();
                        color = Color.deserialize((Map)((Map)map.get(1)));
                        subMeta.setColor(color);
                        itemstack.setItemMeta((ItemMeta)subMeta);
                    }
                } else if (rowType == Material.LEATHER_HORSE_ARMOR || rowType == Material.LEATHER_HELMET || rowType == Material.LEATHER_CHESTPLATE || rowType == Material.LEATHER_LEGGINGS || rowType == Material.LEATHER_BOOTS) {
                    for (Map colorData : map) {
                        meta = (LeatherArmorMeta)itemstack.getItemMeta();
                        Color color2 = Color.deserialize((Map)colorData);
                        meta.setColor(color2);
                        itemstack.setItemMeta((ItemMeta)meta);
                    }
                } else if (rowType == Material.POTION) {
                    for (Map potionData : map) {
                        meta = (PotionMeta)itemstack.getItemMeta();
                        PotionEffect effect = new PotionEffect(potionData);
                        meta.addCustomEffect(effect, true);
                        itemstack.setItemMeta((ItemMeta)meta);
                    }
                } else if (rowType.name().endsWith("_BANNER")) {
                    for (Object patternData : map) {
                        meta = (BannerMeta)itemstack.getItemMeta();
                        Pattern pattern = new Pattern((Map)patternData);
                        meta.addPattern(pattern);
                        itemstack.setItemMeta((ItemMeta)meta);
                    }
                } else if (rowType == Material.CROSSBOW) {
                    Object patternData;
                    meta2 = (CrossbowMeta)itemstack.getItemMeta();
                    patternData = map.iterator();
                    while (patternData.hasNext()) {
                        Map itemData = (Map)patternData.next();
                        ItemStack crossbowItem = Util.unserializeItemStack(itemData);
                        if (crossbowItem == null) continue;
                        meta2.addChargedProjectile(crossbowItem);
                    }
                    itemstack.setItemMeta((ItemMeta)meta2);
                } else if (rowType == Material.MAP || rowType == Material.FILLED_MAP) {
                    for (Map colorData : map) {
                        meta = (MapMeta)itemstack.getItemMeta();
                        Color color3 = Color.deserialize((Map)colorData);
                        meta.setColor(color3);
                        itemstack.setItemMeta((ItemMeta)meta);
                    }
                } else if (rowType == Material.FIREWORK_ROCKET || rowType == Material.FIREWORK_STAR) {
                    if (itemCount == 1) {
                        effectBuilder = FireworkEffect.builder();
                        for (Map fireworkData : map) {
                            FireworkEffect.Type type = fireworkData.getOrDefault("type", FireworkEffect.Type.BALL);
                            boolean hasFlicker = (Boolean)fireworkData.get("flicker");
                            boolean hasTrail = (Boolean)fireworkData.get("trail");
                            effectBuilder.with(type);
                            effectBuilder.flicker(hasFlicker);
                            effectBuilder.trail(hasTrail);
                        }
                    } else if (itemCount == 2) {
                        for (Map colorData : map) {
                            color = Color.deserialize((Map)colorData);
                            effectBuilder.withColor(color);
                        }
                    } else if (itemCount == 3) {
                        for (Map colorData : map) {
                            color = Color.deserialize((Map)colorData);
                            effectBuilder.withFade(color);
                        }
                        RollbackUtil.buildFireworkEffect(effectBuilder, rowType, itemstack);
                        itemCount = 0;
                    }
                } else if (rowType == Material.SUSPICIOUS_STEW) {
                    for (Map suspiciousStewData : map) {
                        meta = (SuspiciousStewMeta)itemstack.getItemMeta();
                        PotionEffect effect = new PotionEffect(suspiciousStewData);
                        meta.addCustomEffect(effect, true);
                        itemstack.setItemMeta((ItemMeta)meta);
                    }
                } else {
                    BukkitAdapter.ADAPTER.setItemMeta(rowType, itemstack, map);
                }
                ++itemCount;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new Object[]{slot, faceData, itemstack};
    }

    public static Object[] populateItemStack(ItemStack itemstack, byte[] metadata) {
        if (metadata != null) {
            try {
                ByteArrayInputStream metaByteStream = new ByteArrayInputStream(metadata);
                BukkitObjectInputStream metaObjectStream = new BukkitObjectInputStream((InputStream)metaByteStream);
                Object metaList = metaObjectStream.readObject();
                metaObjectStream.close();
                metaByteStream.close();
                return RollbackUtil.populateItemStack(itemstack, metaList);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return new Object[]{0, "", itemstack};
    }
}

