/*
 * Decompiled with CFR 0.152.
 */
package net.coreprotect.config;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import net.coreprotect.CoreProtect;
import net.coreprotect.config.Config;
import net.coreprotect.config.ConfigHandler;
import net.coreprotect.language.Language;
import net.coreprotect.language.Phrase;

public class ConfigFile
extends Config {
    public static final String CONFIG = "config.yml";
    public static final String LANGUAGE = "language.yml";
    public static final String LANGUAGE_CACHE = ".language";
    private static final TreeMap<String, String> DEFAULT_VALUES = new TreeMap();
    private static final TreeMap<String, String> USER_VALUES = new TreeMap();
    private static final String DEFAULT_FILE_HEADER = "# CoreProtect Language File (en)";
    private final HashMap<String, String> lang = new LinkedHashMap<String, String>();

    public static void init(String fileName) throws IOException {
        for (Phrase phrase : Phrase.values()) {
            DEFAULT_VALUES.put(phrase.name(), phrase.getPhrase());
            USER_VALUES.put(phrase.name(), phrase.getUserPhrase());
        }
        boolean isCache = fileName.startsWith(".");
        ConfigFile.loadFiles(fileName, isCache);
    }

    public void load(InputStream in, String fileName, boolean isCache) throws IOException {
        LinkedHashMap<String, String> newConfig = new LinkedHashMap<String, String>(this.lang.size());
        ConfigFile.load(in, newConfig, true);
        this.lang.clear();
        this.lang.putAll(newConfig);
        for (Map.Entry<String, String> entry : this.lang.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (!DEFAULT_VALUES.containsKey(key) || value.length() <= 0 || isCache && !DEFAULT_VALUES.get(key).equals(USER_VALUES.get(key))) continue;
            Phrase phrase = Phrase.valueOf(key);
            if (!isCache) {
                Language.setUserPhrase(phrase, value);
            }
            Language.setTranslatedPhrase(phrase, value);
        }
    }

    public static void load(InputStream in, Map<String, String> config, boolean forceCase) throws IOException {
        try (InputStream in0 = in;){
            BufferedReader reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
            String line = reader.readLine();
            while (line != null) {
                int split;
                if (!line.startsWith("#") && (split = line.indexOf(58)) != -1) {
                    String key = line.substring(0, split).trim();
                    String value = line.substring(split + 1).trim();
                    if (value.length() >= 2 && value.startsWith("'") && value.endsWith("'")) {
                        value = value.replaceAll("^'|'$", "");
                        value = value.replace("''", "'");
                        value = value.replace("\\'", "'");
                        value = value.replace("\\\\", "\\");
                    } else if (value.length() >= 2 && value.startsWith("\"") && value.endsWith("\"")) {
                        value = value.replaceAll("^\"|\"$", "");
                        value = value.replace("\\\"", "\"");
                        value = value.replace("\\\\", "\\");
                    }
                    if (forceCase) {
                        key = key.toUpperCase(Locale.ROOT);
                    }
                    config.put(key, value);
                }
                line = reader.readLine();
            }
            reader.close();
        }
    }

    private static Map<String, byte[]> loadFiles(String fileName, boolean isCache) throws IOException {
        CoreProtect plugin = CoreProtect.getInstance();
        File configFolder = plugin.getDataFolder();
        if (!configFolder.exists()) {
            configFolder.mkdirs();
        }
        HashMap<String, byte[]> map = new HashMap<String, byte[]>();
        File globalFile = new File(configFolder, fileName);
        if (globalFile.exists()) {
            byte[] data = Files.readAllBytes(globalFile.toPath());
            map.put("config", data);
            ConfigFile temp = new ConfigFile();
            temp.load(new ByteArrayInputStream(data), fileName, isCache);
            temp.addMissingOptions(globalFile);
        } else {
            ConfigFile temp = new ConfigFile();
            temp.addMissingOptions(globalFile);
        }
        return map;
    }

    @Override
    public void addMissingOptions(File file) throws IOException {
        if (file.getName().startsWith(".")) {
            return;
        }
        boolean writeHeader = !file.exists() || file.length() == 0L;
        try (FileOutputStream fout = new FileOutputStream(file, true);){
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)new BufferedOutputStream(fout), StandardCharsets.UTF_8);
            if (writeHeader) {
                out.append(DEFAULT_FILE_HEADER);
                out.append("\n");
            }
            for (Map.Entry<String, String> entry : DEFAULT_VALUES.entrySet()) {
                String key = entry.getKey();
                String defaultValue = entry.getValue().replaceAll("\"", "\\\\\"");
                String configuredValue = this.lang.get(key);
                if (configuredValue != null) continue;
                out.append("\n");
                out.append(key);
                out.append(": ");
                out.append("\"" + defaultValue + "\"");
            }
            out.close();
        }
    }

    public static void modifyLine(String fileName, String oldLine, String newLine) {
        try {
            Path path = Paths.get(ConfigHandler.path + fileName, new String[0]);
            List<String> lines = Files.readAllLines(path);
            for (int i = 0; i < lines.size(); ++i) {
                if (!lines.get(i).equalsIgnoreCase(oldLine)) continue;
                if (newLine != null && newLine.length() > 0) {
                    lines.set(i, newLine);
                    break;
                }
                lines.remove(i);
                break;
            }
            if (lines.size() > 0) {
                String lastLine = lines.get(lines.size() - 1);
                Files.write(path, lines.remove(lines.size() - 1).isEmpty() ? lines : lines, StandardCharsets.UTF_8, new OpenOption[0]);
                Files.write(path, lastLine.getBytes(StandardCharsets.UTF_8), StandardOpenOption.APPEND);
                lines.clear();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void sortFile(String fileName) {
        try {
            Path path = Paths.get(ConfigHandler.path + fileName, new String[0]);
            List<String> lines = Files.readAllLines(path);
            List<String> sort = lines.subList(2, lines.size());
            Collections.sort(sort);
            lines = lines.subList(0, 2);
            lines.addAll(sort);
            if (lines.size() > 0) {
                String lastLine = lines.get(lines.size() - 1);
                Files.write(path, lines.remove(lines.size() - 1).isEmpty() ? lines : lines, StandardCharsets.UTF_8, new OpenOption[0]);
                Files.write(path, lastLine.getBytes(StandardCharsets.UTF_8), StandardOpenOption.APPEND);
                lines.clear();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void resetCache(String cacheName, String fileName) throws IOException {
        File file = new File(CoreProtect.getInstance().getDataFolder(), cacheName);
        if (file.length() > 0L) {
            new FileOutputStream(file).close();
            ConfigFile.init(fileName);
        }
    }
}

