/*
 * Decompiled with CFR 0.152.
 */
package net.coreprotect.listener.block;

import java.util.ArrayList;
import java.util.List;
import net.coreprotect.config.Config;
import net.coreprotect.consumer.Queue;
import net.coreprotect.listener.block.BlockBreakListener;
import net.coreprotect.thread.CacheHandler;
import net.coreprotect.utility.Util;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPistonEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;

public final class BlockPistonListener
extends Queue
implements Listener {
    protected void onBlockPiston(BlockPistonEvent event) {
        List event_blocks = null;
        if (event instanceof BlockPistonExtendEvent) {
            event_blocks = ((BlockPistonExtendEvent)event).getBlocks();
        } else if (event instanceof BlockPistonRetractEvent) {
            event_blocks = ((BlockPistonRetractEvent)event).getBlocks();
        }
        World world = event.getBlock().getWorld();
        if (Config.getConfig((World)world).PISTONS && !event.isCancelled()) {
            ArrayList<Block> nblocks = new ArrayList<Block>();
            ArrayList<Block> blocks = new ArrayList<Block>();
            for (Block block : event_blocks) {
                Block block_relative = block.getRelative(event.getDirection());
                nblocks.add(block_relative);
                blocks.add(block);
            }
            Block b = event.getBlock();
            BlockFace d = event.getDirection();
            Block bm = b.getRelative(d);
            int wid = Util.getWorldId(bm.getWorld().getName());
            int unixtimestamp = (int)(System.currentTimeMillis() / 1000L);
            boolean log = false;
            for (int l = 0; l <= nblocks.size(); ++l) {
                Material t;
                int z;
                int y;
                int ll = l - 1;
                Block n = null;
                n = ll == -1 ? bm : (Block)nblocks.get(ll);
                if (n == null) continue;
                int x = n.getX();
                String cords = x + "." + (y = n.getY()) + "." + (z = n.getZ()) + "." + wid + "." + (t = n.getType()).name();
                if (CacheHandler.pistonCache.get(cords) == null) {
                    log = true;
                }
                CacheHandler.pistonCache.put(cords, new Object[]{unixtimestamp});
            }
            if (log) {
                String e = "#piston";
                for (Block block : blocks) {
                    BlockBreakListener.processBlockBreak(null, e, block, true, 0);
                }
                int c = 0;
                for (Block nblock : nblocks) {
                    BlockState block = ((Block)blocks.get(c)).getState();
                    BlockPistonListener.queueBlockPlaceValidate(e, nblock.getState(), nblock, null, block.getType(), -1, 0, block.getBlockData().getAsString(), 3);
                    ++c;
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    protected void onBlockPistonExtend(BlockPistonExtendEvent event) {
        this.onBlockPiston((BlockPistonEvent)event);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    protected void onBlockPistonRetract(BlockPistonRetractEvent event) {
        this.onBlockPiston((BlockPistonEvent)event);
    }
}

