/*
 * Decompiled with CFR 0.152.
 */
package net.coreprotect.listener.player;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.coreprotect.CoreProtect;
import net.coreprotect.config.Config;
import net.coreprotect.config.ConfigHandler;
import net.coreprotect.listener.player.InventoryChangeListener;
import net.coreprotect.thread.Scheduler;
import net.coreprotect.utility.Util;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public final class HopperPushListener {
    static void processHopperPush(Location location, String user, InventoryHolder sourceHolder, InventoryHolder destinationHolder, ItemStack item) {
        Location destinationLocation = destinationHolder.getInventory().getLocation();
        if (destinationLocation == null) {
            return;
        }
        String loggingChestId = "#hopper-push." + destinationLocation.getBlockX() + "." + destinationLocation.getBlockY() + "." + destinationLocation.getBlockZ();
        Object[] lastAbort = ConfigHandler.hopperAbort.get(loggingChestId);
        if (lastAbort != null) {
            Object[] destinationContents = destinationHolder.getInventory().getContents();
            if (((Set)lastAbort[0]).contains(item) && Arrays.equals(destinationContents, (ItemStack[])lastAbort[1])) {
                return;
            }
        }
        ItemStack[] destinationContainer = Util.getContainerState(destinationHolder.getInventory().getContents());
        ItemStack movedItem = item.clone();
        long taskStarted = InventoryChangeListener.tasksStarted.incrementAndGet();
        Scheduler.runTaskAsynchronously(CoreProtect.getInstance(), () -> {
            try {
                if (sourceHolder == null || destinationHolder == null) {
                    return;
                }
                boolean abort = false;
                boolean addedInventory = Util.canAddContainer(destinationContainer, movedItem, destinationHolder.getInventory().getMaxStackSize());
                if (!addedInventory) {
                    abort = true;
                }
                if (abort) {
                    HashSet<ItemStack> movedItems = new HashSet<ItemStack>();
                    Object[] destinationContents = destinationHolder.getInventory().getContents();
                    if (lastAbort != null && Arrays.equals(destinationContents, (ItemStack[])lastAbort[1])) {
                        ((Set)lastAbort[0]).forEach(itemStack -> movedItems.add((ItemStack)itemStack));
                    }
                    movedItems.add(movedItem);
                    ConfigHandler.hopperAbort.put(loggingChestId, new Object[]{movedItems, Util.getContainerState((ItemStack[])destinationContents)});
                    return;
                }
                ConfigHandler.hopperSuccess.put(loggingChestId, new Object[]{destinationContainer, movedItem});
                List<Object> list = ConfigHandler.transactingChest.get(location.getWorld().getUID().toString() + "." + location.getBlockX() + "." + location.getBlockY() + "." + location.getBlockZ());
                if (list != null) {
                    list.add(movedItem);
                }
                if (Config.getConfig((World)location.getWorld()).HOPPER_FILTER_META && !movedItem.hasItemMeta()) {
                    return;
                }
                Inventory destinationInventory = destinationHolder.getInventory();
                ItemStack[] originalDestination = (ItemStack[])destinationInventory.getContents().clone();
                int removeAmount = movedItem.getAmount();
                for (int i = 0; i < originalDestination.length && removeAmount != 0; ++i) {
                    ItemStack itemStack2;
                    ItemStack itemStack3 = itemStack2 = originalDestination[i] != null ? originalDestination[i].clone() : null;
                    if (itemStack2 == null || !itemStack2.isSimilar(movedItem)) continue;
                    if (itemStack2.getAmount() >= removeAmount) {
                        itemStack2.setAmount(itemStack2.getAmount() - removeAmount);
                        removeAmount = 0;
                    } else {
                        removeAmount -= itemStack2.getAmount();
                        itemStack2 = null;
                    }
                    originalDestination[i] = itemStack2;
                }
                InventoryChangeListener.checkTasks(taskStarted);
                InventoryChangeListener.onInventoryInteract(user, destinationInventory, originalDestination, null, destinationInventory.getLocation(), true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }
}

