/*
 * Decompiled with CFR 0.152.
 */
package net.coreprotect.command;

import java.sql.Connection;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.coreprotect.command.CommandHandler;
import net.coreprotect.command.LookupCommand;
import net.coreprotect.config.Config;
import net.coreprotect.config.ConfigHandler;
import net.coreprotect.database.ContainerRollback;
import net.coreprotect.database.Database;
import net.coreprotect.database.lookup.PlayerLookup;
import net.coreprotect.database.rollback.Rollback;
import net.coreprotect.language.Phrase;
import net.coreprotect.utility.Chat;
import net.coreprotect.utility.Color;
import net.coreprotect.utility.Util;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Chest;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;

public class RollbackRestoreCommand {
    protected static void runCommand(final CommandSender player, Command command, boolean permission, String[] args, Location argLocation, long forceStart, long forceEnd) {
        Object[] lookupThrottle;
        Location lo = argLocation != null ? argLocation : CommandHandler.parseLocation(player, args);
        ArrayList argUuids = new ArrayList();
        List<String> argUsers = CommandHandler.parseUsers(args);
        Integer[] argRadius = CommandHandler.parseRadius(args, player, lo);
        int argNoisy = CommandHandler.parseNoisy(args);
        List<Integer> argAction = CommandHandler.parseAction(args);
        List<Object> argBlocks = CommandHandler.parseRestricted(player, args, argAction);
        Map<Object, Boolean> argExclude = CommandHandler.parseExcluded(player, args, argAction);
        List<String> argExcludeUsers = CommandHandler.parseExcludedUsers(player, args);
        String ts = CommandHandler.parseTimeString(args);
        long[] argTime = CommandHandler.parseTime(args);
        long startTime = argTime[0];
        long endTime = argTime[1];
        int argWid = CommandHandler.parseWorld(args, true, true);
        boolean count = CommandHandler.parseCount(args);
        boolean worldedit = CommandHandler.parseWorldEdit(args);
        boolean forceglobal = CommandHandler.parseForceGlobal(args);
        int preview = CommandHandler.parsePreview(args);
        String corecommand = args[0].toLowerCase(Locale.ROOT);
        if (argBlocks == null || argExclude == null || argExcludeUsers == null) {
            return;
        }
        boolean hasBlock = false;
        boolean hasEntity = false;
        for (Object arg : argBlocks) {
            if (arg instanceof Material) {
                hasBlock = true;
                continue;
            }
            if (!(arg instanceof EntityType)) continue;
            hasEntity = true;
            if (argAction.size() == 0) {
                argAction.add(3);
                continue;
            }
            if (argAction.contains(3)) continue;
            Chat.sendMessage(player, Color.DARK_AQUA + "CoreProtect " + Color.WHITE + "- " + Phrase.build(Phrase.INVALID_INCLUDE_COMBO, new String[0]));
            return;
        }
        for (Object arg : argExclude.keySet()) {
            if (arg instanceof Material) {
                hasBlock = true;
                continue;
            }
            if (!(arg instanceof EntityType)) continue;
            hasEntity = true;
            if (argAction.size() == 0) {
                argAction.add(3);
                continue;
            }
            if (argAction.contains(3)) continue;
            Chat.sendMessage(player, Color.DARK_AQUA + "CoreProtect " + Color.WHITE + "- " + Phrase.build(Phrase.INVALID_INCLUDE_COMBO, new String[0]));
            return;
        }
        if (hasBlock && hasEntity) {
            Chat.sendMessage(player, Color.DARK_AQUA + "CoreProtect " + Color.WHITE + "- " + Phrase.build(Phrase.INVALID_INCLUDE_COMBO, new String[0]));
            return;
        }
        if (count) {
            LookupCommand.runCommand(player, command, permission, args);
            return;
        }
        if (ConfigHandler.converterRunning) {
            Chat.sendMessage(player, Color.DARK_AQUA + "CoreProtect " + Color.WHITE + "- " + Phrase.build(Phrase.UPGRADE_IN_PROGRESS, new String[0]));
            return;
        }
        if (ConfigHandler.purgeRunning) {
            Chat.sendMessage(player, Color.DARK_AQUA + "CoreProtect " + Color.WHITE + "- " + Phrase.build(Phrase.PURGE_IN_PROGRESS, new String[0]));
            return;
        }
        if (argWid == -1) {
            String worldName = CommandHandler.parseWorldName(args, true);
            Chat.sendMessage(player, Color.DARK_AQUA + "CoreProtect " + Color.WHITE + "- " + Phrase.build(Phrase.WORLD_NOT_FOUND, worldName));
            return;
        }
        if (preview > 0 && !(player instanceof Player)) {
            Chat.sendMessage(player, Color.DARK_AQUA + "CoreProtect " + Color.WHITE + "- " + Phrase.build(Phrase.PREVIEW_IN_GAME, new String[0]));
            return;
        }
        if (argAction.contains(-1)) {
            Chat.sendMessage(player, Color.DARK_AQUA + "CoreProtect " + Color.WHITE + "- " + Phrase.build(Phrase.INVALID_ACTION, new String[0]));
            return;
        }
        if (worldedit && argRadius == null) {
            Chat.sendMessage(player, Color.DARK_AQUA + "CoreProtect " + Color.WHITE + "- " + Phrase.build(Phrase.INVALID_SELECTION, "WorldEdit"));
            return;
        }
        if (argRadius != null && argRadius[0] == -1) {
            Chat.sendMessage(player, Color.DARK_AQUA + "CoreProtect " + Color.WHITE + "- " + Phrase.build(Phrase.INVALID_RADIUS, new String[0]));
            return;
        }
        if (ConfigHandler.activeRollbacks.get(player.getName()) != null) {
            Chat.sendMessage(player, Color.DARK_AQUA + "CoreProtect " + Color.WHITE + "- " + Phrase.build(Phrase.ROLLBACK_IN_PROGRESS, new String[0]));
            return;
        }
        if (ConfigHandler.lookupThrottle.get(player.getName()) != null && (((Boolean)(lookupThrottle = ConfigHandler.lookupThrottle.get(player.getName()))[0]).booleanValue() || System.currentTimeMillis() - (Long)lookupThrottle[1] < 100L)) {
            Chat.sendMessage(player, Color.DARK_AQUA + "CoreProtect " + Color.WHITE + "- " + Phrase.build(Phrase.DATABASE_BUSY, new String[0]));
            return;
        }
        if (preview > 1 && forceStart <= 0L) {
            preview = 1;
        }
        if (permission) {
            int a = 0;
            if (corecommand.equals("restore") || corecommand.equals("rs") || corecommand.equals("re")) {
                a = 1;
            }
            final int finalAction = a;
            int DEFAULT_RADIUS = Config.getGlobal().DEFAULT_RADIUS;
            if ((player instanceof Player || player instanceof BlockCommandSender) && argRadius == null && DEFAULT_RADIUS > 0 && !forceglobal && !argAction.contains(11)) {
                Location location = lo;
                int xmin = location.getBlockX() - DEFAULT_RADIUS;
                int xmax = location.getBlockX() + DEFAULT_RADIUS;
                int zmin = location.getBlockZ() - DEFAULT_RADIUS;
                int zmax = location.getBlockZ() + DEFAULT_RADIUS;
                argRadius = new Integer[]{DEFAULT_RADIUS, xmin, xmax, null, null, zmin, zmax, 0};
            }
            boolean g = true;
            if (argUsers.contains("#global") && argRadius == null) {
                g = false;
            }
            if (argUsers.size() == 0 && (argWid > 0 || forceglobal) && argRadius == null) {
                if (finalAction == 0) {
                    Chat.sendMessage(player, Color.DARK_AQUA + "CoreProtect " + Color.WHITE + "- " + Phrase.build(Phrase.MISSING_ROLLBACK_USER, "{1}"));
                } else {
                    Chat.sendMessage(player, Color.DARK_AQUA + "CoreProtect " + Color.WHITE + "- " + Phrase.build(Phrase.MISSING_ROLLBACK_USER, "{2}"));
                }
                return;
            }
            if (argAction.contains(4) && argAction.contains(11)) {
                if (argUsers.size() == 0) {
                    Chat.sendMessage(player, Color.DARK_AQUA + "CoreProtect " + Color.WHITE + "- " + Phrase.build(Phrase.MISSING_ACTION_USER, new String[0]));
                    return;
                }
                argExclude.put(Material.FIRE, false);
                argExclude.put(Material.WATER, false);
                argExclude.put(Material.FARMLAND, false);
                argExcludeUsers.add("#hopper");
            } else if (!argAction.contains(4) && Config.getGlobal().EXCLUDE_TNT && !argExclude.containsKey(Material.TNT) && !argBlocks.contains(Material.TNT)) {
                argExclude.put(Material.TNT, true);
            }
            if (g && (argUsers.size() > 0 || argUsers.size() == 0 && argRadius != null)) {
                int radiusValue;
                Integer MAX_RADIUS = Config.getGlobal().MAX_RADIUS;
                if (argRadius != null && (radiusValue = argRadius[0].intValue()) > MAX_RADIUS && MAX_RADIUS > 0) {
                    Chat.sendMessage(player, Color.DARK_AQUA + "CoreProtect " + Color.WHITE + "- " + Phrase.build(Phrase.MAXIMUM_RADIUS, MAX_RADIUS.toString(), finalAction == 0 ? "{2}" : "{3}"));
                    Chat.sendMessage(player, Color.DARK_AQUA + "CoreProtect " + Color.WHITE + "- " + Phrase.build(Phrase.GLOBAL_ROLLBACK, "r:#global", finalAction == 0 ? "{1}" : "{2}"));
                    return;
                }
                if (argAction.size() > 0) {
                    if (argAction.contains(4)) {
                        if (argUsers.contains("#global") || argUsers.size() == 0 && argRadius == null) {
                            Chat.sendMessage(player, Color.DARK_AQUA + "CoreProtect " + Color.WHITE + "- " + Phrase.build(Phrase.MISSING_ACTION_USER, new String[0]));
                            return;
                        }
                        if (preview > 0) {
                            Chat.sendMessage(player, Color.DARK_AQUA + "CoreProtect " + Color.WHITE + "- " + Phrase.build(Phrase.PREVIEW_TRANSACTION, !argAction.contains(11) ? "{1}" : "{2}"));
                            return;
                        }
                    }
                    if (argAction.contains(8) || argAction.contains(11) && !argAction.contains(4) || !argAction.contains(0) && !argAction.contains(1) && !argAction.contains(3) && !argAction.contains(4)) {
                        if (finalAction == 0) {
                            Chat.sendMessage(player, Color.DARK_AQUA + "CoreProtect " + Color.WHITE + "- " + Phrase.build(Phrase.ACTION_NOT_SUPPORTED, new String[0]));
                        } else {
                            Chat.sendMessage(player, Color.DARK_AQUA + "CoreProtect " + Color.WHITE + "- " + Phrase.build(Phrase.ACTION_NOT_SUPPORTED, new String[0]));
                        }
                        return;
                    }
                }
                if (argUsers.size() == 0) {
                    argUsers.add("#global");
                }
                List<String> rollbackusers = argUsers;
                int c = 0;
                for (String ruser : rollbackusers) {
                    Player onlineUser;
                    List players = Bukkit.getServer().matchPlayer(ruser);
                    for (Player p : players) {
                        if (!p.getName().equalsIgnoreCase(ruser)) continue;
                        ruser = p.getName();
                        rollbackusers.set(c, ruser);
                    }
                    ++c;
                    if (!argAction.contains(4) || !argAction.contains(11) || (onlineUser = Bukkit.getServer().getPlayer(ruser)) != null && onlineUser.isOnline()) continue;
                    Chat.sendMessage(player, Color.DARK_AQUA + "CoreProtect " + Color.WHITE + "- " + Phrase.build(Phrase.USER_OFFLINE, ruser));
                    return;
                }
                int wid = 0;
                int x = 0;
                int y = 0;
                int z = 0;
                if (rollbackusers.contains("#container")) {
                    if (argAction.contains(11)) {
                        Chat.sendMessage(player, Color.DARK_AQUA + "CoreProtect " + Color.WHITE + "- " + Phrase.build(Phrase.INVALID_USERNAME, "#container"));
                        return;
                    }
                    boolean valid = false;
                    if (ConfigHandler.lookupType.get(player.getName()) != null) {
                        int lookupType = ConfigHandler.lookupType.get(player.getName());
                        if (lookupType == 1) {
                            valid = true;
                        } else if (lookupType == 5 && ConfigHandler.lookupUlist.get(player.getName()).contains("#container")) {
                            valid = true;
                        }
                    }
                    if (valid) {
                        if (preview > 0) {
                            Chat.sendMessage(player, Color.DARK_AQUA + "CoreProtect " + Color.WHITE + "- " + Phrase.build(Phrase.PREVIEW_TRANSACTION, "{1}"));
                            return;
                        }
                        String lcommand = ConfigHandler.lookupCommand.get(player.getName());
                        String[] data = lcommand.split("\\.");
                        x = Integer.parseInt(data[0]);
                        y = Integer.parseInt(data[1]);
                        z = Integer.parseInt(data[2]);
                        wid = Integer.parseInt(data[3]);
                        argAction.add(5);
                        argRadius = null;
                        argWid = 0;
                        lo = new Location(Bukkit.getServer().getWorld(Util.getWorldName(wid)), (double)x, (double)y, (double)z);
                        Block block = lo.getBlock();
                        if (block.getState() instanceof Chest) {
                            BlockFace[] blockFaces;
                            for (BlockFace face : blockFaces = new BlockFace[]{BlockFace.NORTH, BlockFace.EAST, BlockFace.SOUTH, BlockFace.WEST}) {
                                if (!(block.getRelative(face, 1).getState() instanceof Chest)) continue;
                                Block relative = block.getRelative(face, 1);
                                int x2 = relative.getX();
                                int z2 = relative.getZ();
                                double newX = (double)(x + x2) / 2.0;
                                double newZ = (double)(z + z2) / 2.0;
                                lo.setX(newX);
                                lo.setZ(newZ);
                                break;
                            }
                        }
                    } else {
                        Chat.sendMessage(player, Color.DARK_AQUA + "CoreProtect " + Color.WHITE + "- " + Phrase.build(Phrase.INVALID_CONTAINER, new String[0]));
                        return;
                    }
                }
                final List<String> rollbackusers2 = rollbackusers;
                if (startTime > 0L) {
                    long timeEnd;
                    long unixtimestamp = System.currentTimeMillis() / 1000L;
                    long timeStart = unixtimestamp - startTime;
                    long l = timeEnd = endTime > 0L ? unixtimestamp - endTime : 0L;
                    if (forceStart > 0L) {
                        timeStart = forceStart;
                        timeEnd = forceEnd;
                    }
                    final long finalTimeStart = timeStart;
                    final long finalTimeEnd = timeEnd;
                    final Integer[] radius = argRadius;
                    try {
                        final CommandSender player2 = player;
                        final int noisy = argNoisy;
                        final String rtime = ts;
                        final ArrayList uuidList = argUuids;
                        final List<Object> blist = argBlocks;
                        final Map<Object, Boolean> elist = argExclude;
                        final List<String> euserlist = argExcludeUsers;
                        final Location locationFinal = lo;
                        final int finalArgWid = argWid;
                        final List<Integer> finalArgAction = argAction;
                        final String[] finalArgs = args;
                        final int finalPreview = preview;
                        ConfigHandler.activeRollbacks.put(player.getName(), true);
                        class BasicThread2
                        implements Runnable {
                            BasicThread2() {
                            }

                            @Override
                            public void run() {
                                try (Connection connection = Database.getConnection(false, 1000);){
                                    ConfigHandler.lookupThrottle.put(player.getName(), new Object[]{true, System.currentTimeMillis()});
                                    int action = finalAction;
                                    Location location = locationFinal;
                                    if (connection != null) {
                                        Statement statement = connection.createStatement();
                                        String baduser = "";
                                        boolean exists = false;
                                        for (String check : rollbackusers2) {
                                            if (!check.equals("#global") && !check.equals("#container")) {
                                                exists = PlayerLookup.playerExists(connection, check);
                                                if (exists) continue;
                                                baduser = check;
                                                break;
                                            }
                                            exists = true;
                                        }
                                        if (exists) {
                                            for (String check : euserlist) {
                                                if (!check.equals("#global") && !check.equals("#hopper")) {
                                                    exists = PlayerLookup.playerExists(connection, check);
                                                    if (exists) continue;
                                                    baduser = check;
                                                    break;
                                                }
                                                if (!check.equals("#global")) continue;
                                                baduser = "#global";
                                                exists = false;
                                            }
                                        }
                                        if (exists) {
                                            boolean restrictWorld = false;
                                            if (radius != null) {
                                                restrictWorld = true;
                                            }
                                            if (location == null) {
                                                restrictWorld = false;
                                            }
                                            if (finalArgWid > 0) {
                                                restrictWorld = true;
                                                location = new Location(Bukkit.getServer().getWorld(Util.getWorldName(finalArgWid)), 0.0, 0.0, 0.0);
                                            }
                                            boolean verbose = false;
                                            if (noisy == 1) {
                                                verbose = true;
                                            }
                                            Object users = "";
                                            for (String value : rollbackusers2) {
                                                if (((String)users).length() == 0) {
                                                    users = value;
                                                    continue;
                                                }
                                                users = (String)users + ", " + value;
                                            }
                                            if (((String)users).equals("#global") && restrictWorld) {
                                                users = "#" + location.getWorld().getName();
                                            }
                                            if (finalPreview == 2) {
                                                Chat.sendMessage(player2, Color.DARK_AQUA + "CoreProtect " + Color.WHITE + "- " + Phrase.build(Phrase.PREVIEW_CANCELLING, new String[0]));
                                            } else if (finalPreview == 1) {
                                                Chat.sendMessage(player2, Color.DARK_AQUA + "CoreProtect " + Color.WHITE + "- " + Phrase.build(Phrase.ROLLBACK_STARTED, new String[]{users, "{3}"}));
                                            } else if (action == 0) {
                                                Chat.sendMessage(player2, Color.DARK_AQUA + "CoreProtect " + Color.WHITE + "- " + Phrase.build(Phrase.ROLLBACK_STARTED, new String[]{users, "{1}"}));
                                            } else {
                                                Chat.sendMessage(player2, Color.DARK_AQUA + "CoreProtect " + Color.WHITE + "- " + Phrase.build(Phrase.ROLLBACK_STARTED, new String[]{users, "{2}"}));
                                            }
                                            if (finalArgAction.contains(5)) {
                                                ContainerRollback.performContainerRollbackRestore(statement, player2, uuidList, rollbackusers2, rtime, blist, elist, euserlist, finalArgAction, location, radius, finalTimeStart, finalTimeEnd, restrictWorld, false, verbose, action);
                                            } else {
                                                Rollback.performRollbackRestore(statement, player2, uuidList, rollbackusers2, rtime, blist, elist, euserlist, finalArgAction, location, radius, finalTimeStart, finalTimeEnd, restrictWorld, false, verbose, action, finalPreview);
                                            }
                                            if (finalPreview < 2) {
                                                ArrayList<Object> list = new ArrayList<Object>();
                                                list.add(finalTimeStart);
                                                list.add(finalTimeEnd);
                                                list.add(finalArgs);
                                                list.add(locationFinal);
                                                ConfigHandler.lastRollback.put(player2.getName(), list);
                                            }
                                        } else {
                                            Chat.sendMessage(player2, Color.DARK_AQUA + "CoreProtect " + Color.WHITE + "- " + Phrase.build(Phrase.USER_NOT_FOUND, baduser));
                                        }
                                        statement.close();
                                    } else {
                                        Chat.sendMessage(player2, Color.DARK_AQUA + "CoreProtect " + Color.WHITE + "- " + Phrase.build(Phrase.DATABASE_BUSY, new String[0]));
                                    }
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                                if (ConfigHandler.activeRollbacks.get(player2.getName()) != null) {
                                    ConfigHandler.activeRollbacks.remove(player2.getName());
                                }
                                ConfigHandler.lookupThrottle.put(player2.getName(), new Object[]{false, System.currentTimeMillis()});
                            }
                        }
                        BasicThread2 runnable = new BasicThread2();
                        Thread thread = new Thread(runnable);
                        thread.start();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else if (finalAction == 0) {
                    Chat.sendMessage(player, Color.DARK_AQUA + "CoreProtect " + Color.WHITE + "- " + Phrase.build(Phrase.MISSING_LOOKUP_TIME, "{2}"));
                } else {
                    Chat.sendMessage(player, Color.DARK_AQUA + "CoreProtect " + Color.WHITE + "- " + Phrase.build(Phrase.MISSING_LOOKUP_TIME, "{3}"));
                }
            } else if (finalAction == 0) {
                Chat.sendMessage(player, Color.DARK_AQUA + "CoreProtect " + Color.WHITE + "- " + Phrase.build(Phrase.MISSING_ROLLBACK_RADIUS, "{1}"));
            } else {
                Chat.sendMessage(player, Color.DARK_AQUA + "CoreProtect " + Color.WHITE + "- " + Phrase.build(Phrase.MISSING_ROLLBACK_RADIUS, "{2}"));
            }
        } else {
            Chat.sendMessage(player, Color.DARK_AQUA + "CoreProtect " + Color.WHITE + "- " + Phrase.build(Phrase.NO_PERMISSION, new String[0]));
        }
    }
}

